/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
draw_occupant_images();

/**
 * Draw occupant body region scoring indicator images for the specified models
 */
function draw_occupant_images() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let output_dir = get_expanded_variable_value(templ, `OUTPUT_DIR`);
    if (!output_dir) {
        LogError(`Could not find OUTPUT_DIR variable for writing occupant image files.`);
        return;
    } else if (!File.IsDirectory(output_dir)) {
        LogError(`OUTPUT_DIR is not a valid directory: ${output_dir}`);
        return;
    }

    let occupants = ["DRIVER"];
    for (let m of models) {
        for (let occ of occupants) {
            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            let head_score = get_variable_value(status, `${m}_${occ}_HEAD_FINAL_SCORE`, "float");
            let chest_score = get_variable_value(status, `${m}_${occ}_CHEST_FINAL_SCORE`, "float");
            let abdomen_score = get_variable_value(status, `${m}_${occ}_ABDOMEN_SCORE`, "float");
            let pelvis_score = get_variable_value(status, `${m}_${occ}_PELVIS_FORCE_SCORE`, "float");
            let foot_score = null; // Foot score only for driver
            if (occ == "DRIVER") {
                foot_score = get_variable_value(status, `${m}_${occ}_FOOT_AND_ANKLE_SCORE`, "float");
            }

            if (!status.success) {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} body region score indicator images`);
            }

            /* Create new image */
            let img = new Image(190, 342);
            img.lineWidth = 1;
            img.lineColour = "black";

            /* Draw the body regions */

            draw_front_view_head(img, get_fill_colour_EuroNCAP_2026(head_score));
            draw_front_view_neck(img, get_fill_colour_EuroNCAP_2026(null));
            draw_front_view_chest(img, get_fill_colour_EuroNCAP_2026(chest_score));
            draw_front_view_abdomen(img, get_fill_colour_EuroNCAP_2026(abdomen_score));
            draw_front_view_left_femur(img, get_fill_colour_EuroNCAP_2026(pelvis_score));
            draw_front_view_right_femur(img, get_fill_colour_EuroNCAP_2026(pelvis_score));
            draw_front_view_left_tibia(img, get_fill_colour_EuroNCAP_2026(null)); // not applicable for virtual testing
            draw_front_view_right_tibia(img, get_fill_colour_EuroNCAP_2026(null)); // not applicable for virtual testing
            draw_front_view_left_foot(img, get_fill_colour_EuroNCAP_2026(null)); // not applicable for virtual testing
            draw_front_view_right_foot(img, get_fill_colour_EuroNCAP_2026(null)); // not applicable for virtual testing
            draw_front_view_left_arm(img, occ); // Not coloured in; not applicable for virtual testing
            draw_front_view_right_arm(img, occ); // Not coloured in; not applicable for virtual testing
            if (occ == "DRIVER") {
                draw_front_view_steering_wheel(img);
            }
            draw_front_view_seatbelt(img, occ);

            img.Save(`${output_dir}/${m}_${occ.toLowerCase()}_plot.png`, Image.PNG);
        }
    }
}
